<?php
namespace TokenMonitor;

class Database {
    private static $instance = null;
    private $connection;

    private function __construct($config) {
        try {
            $this->connection = new \mysqli(
                $config['host'],
                $config['user'],
                $config['pass'],
                $config['dbname']
            );
            
            if ($this->connection->connect_error) {
                throw new \Exception("Connection failed: " . $this->connection->connect_error);
            }
            
            $this->connection->set_charset($config['charset']);
            
            // تست اتصال
            if (!$this->connection->ping()) {
                throw new \Exception("Database connection test failed");
            }
        } catch (\Exception $e) {
            throw new \Exception("Database connection failed: " . $e->getMessage());
        }
    }

    public static function getInstance($config) {
        if (self::$instance === null) {
            self::$instance = new self($config);
        }
        return self::$instance;
    }

    public function getConnection() {
        return $this->connection;
    }

    public function query($sql) {
        $result = $this->connection->query($sql);
        if ($result === false) {
            throw new \Exception("Query failed: " . $this->connection->error);
        }
        return $result;
    }

    public function prepare($sql) {
        $stmt = $this->connection->prepare($sql);
        if ($stmt === false) {
            throw new \Exception("Prepare failed: " . $this->connection->error);
        }
        return $stmt;
    }

    public function escapeString($str) {
        return $this->connection->real_escape_string($str);
    }
}