# مانیتور توکن‌های سولانا

این پروژه یک سیستم مانیتورینگ هوشمند برای شناسایی و تحلیل توکن‌های جدید در شبکه سولانا است.

## قابلیت‌ها

- مانیتورینگ خودکار توکن‌های جدید در پینک‌سیل
- تحلیل تکنیکال و فاندامنتال توکن‌ها
- تحلیل شبکه‌های اجتماعی و تیم پروژه
- ارزیابی ریسک و امتیازدهی هوشمند
- ارسال سیگنال‌های خرید و هشدارهای ریسک
- ارائه تحلیل روزانه از بازار
- مانیتورینگ مداوم تغییرات قیمت، حجم و تعداد هولدرها

## پیش‌نیازها

- PHP 7.4 یا بالاتر
- MySQL 5.7 یا بالاتر
- Composer
- دسترسی به cron jobs
- ربات تلگرام

## نصب و راه‌اندازی

1. کلون کردن پروژه:
```bash
git clone https://github.com/yourusername/solana-token-monitor.git
cd solana-token-monitor
```

2. نصب وابستگی‌ها:
```bash
composer install
```

3. ایجاد دیتابیس:
```sql
CREATE DATABASE token_monitor CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

4. ایجاد فایل کانفیگ:
```bash
cp config/config.example.php config/config.php
```

5. ویرایش فایل کانفیگ و وارد کردن اطلاعات:
   - تنظیمات دیتابیس
   - توکن ربات تلگرام
   - API key های مورد نیاز

6. اجرای مایگریشن‌های دیتابیس:
```bash
php database/migrate.php
```

7. تنظیم cron job برای اجرای خودکار:
```bash
*/5 * * * * php /path/to/project/cron/monitor.php
0 0 * * * php /path/to/project/cron/daily_analysis.php
```

## ساختار پروژه

```
/token-monitor/
├── config/                  # فایل‌های کانفیگ
├── src/                    # کلاس‌های اصلی
├── database/               # مایگریشن‌ها و اسکیما
├── cron/                   # اسکریپت‌های کرون
├── logs/                   # لاگ‌ها
└── public/                 # فایل‌های عمومی
```

## کلاس‌های اصلی

- `TokenMonitor`: مانیتورینگ اصلی توکن‌ها
- `PriceAnalyzer`: تحلیل قیمت و تکنیکال
- `RiskAnalyzer`: تحلیل ریسک‌ها
- `SocialAnalyzer`: تحلیل شبکه‌های اجتماعی
- `TelegramBot`: ارسال نوتیفیکیشن‌ها

## نحوه استفاده

بعد از نصب و راه‌اندازی، سیستم به صورت خودکار شروع به کار می‌کند:

1. هر 5 دقیقه یکبار توکن‌های جدید را بررسی می‌کند
2. برای توکن‌های مناسب سیگنال صادر می‌کند
3. تغییرات مهم را گزارش می‌دهد
4. در پایان هر روز تحلیل کلی ارائه می‌دهد

## وب‌هوک‌های تلگرام

برای دریافت دستورات از تلگرام، نیاز است وب‌هوک تلگرام را تنظیم کنید:

```bash
curl -F "url=https://your-domain.com/public/telegram-webhook.php" \
     https://api.telegram.org/bot<BOT_TOKEN>/setWebhook
```

## امنیت

- همیشه از HTTPS استفاده کنید
- فایل‌های کانفیگ را خارج از دسترس عموم قرار دهید
- API key ها را در محیط امن نگهداری کنید
- دسترسی‌های دیتابیس را محدود کنید

## مشارکت

1. پروژه را fork کنید
2. یک branch جدید ایجاد کنید
3. تغییرات خود را commit کنید
4. یک pull request ایجاد کنید

## لایسنس

MIT License

## تماس

برای گزارش باگ یا پیشنهاد قابلیت جدید، لطفاً یک issue ایجاد کنید.